
// Neurosis Engine - LP23.com
// Copyright  Luigi Pino. All rights reserved.

/***************************************************************************/

#ifndef _NEUROSIS_ENGINE_PHYSICS_H_
#define _NEUROSIS_ENGINE_PHYSICS_H_

/***************************************************************************/

class CNeurosisPhysics {
	public:
		CNeurosisPhysics();
		//! Constructor/Deconstructor
		~CNeurosisPhysics();

		//! Returns closest point on line [linePoint1, linePoint2] to point
		static float3	Calculate_Closest_Point_On_Line_2D(float3 *linePoint1, float3 *linePoint2, float3 *point);
		//! model1 vertices vs. model2 faces.
		//! To check all model2 faces, set iMesh == -1.
		//! Returns averaged collision point (0.0f, 0.0f, 0.0f if none).
		static float3	Collision_Model_VS_Model(CNeurosisModel *model1, CNeurosisModel *model2, int iMesh);
		//!	Sphere vs. model - to check all the faces of model, set iMesh == -1.
		static bool		Collision_Sphere_VS_Model(CNeurosisModel *sphere, CNeurosisModel *model, int iMesh, bool react);
		//!	Sphere vs. model - to check all the faces of model, set iMesh == -1.
		//!	Will only use points that are <= 0.1f for calculations.
		static bool		Collision_Sphere_VS_Model_2D(CNeurosisModel *sphere, CNeurosisModel *model, int iMesh, bool react);
		//!	Sphere vs. sphere
		static bool		Collision_Sphere_VS_Sphere(CNeurosisModel *sphere1, CNeurosisModel *sphere2, float timeStep, bool react);
};

/***************************************************************************/
#endif